#!/usr/bin/perl -w

use IO::Handle;         #autoflush
use File::Copy;     # copy a file
use strict;
use warnings;
use LWP::Simple; 


#*** If there are no arguments provided script exits writing "..."
if (@ARGV <2){print "USAGE:  perl ./score_file2cov_file.pl <scores file> (scores column)\n"; exit};

my $rfile = $ARGV[0];
my $col = $ARGV[1]-1;

#Open ranks file 
open (RFILE, $rfile) || die ("Could not find the file: $rfile");

my $newname=$rfile; while ($newname!~/\.$/ and $newname=~/\./) {$newname=substr($newname,0,-1)};
if($newname!~/\./){$newname=$newname.".cov"}else{$newname=$newname."cov"};

open (NFILE, ">$newname") || die ("Could not open $newname file \n");

#Read rank file to calculate coverages:
my %numb; my @r; my $cnt=0;
while (my $text1 = <RFILE>) {
   next if ($text1 =~ /^[%#]/ or $text1 !~ /\w/);
   $text1=~s/\n//;
   my @a=split(/\t/,$text1);
   my $rank=$a[$col];
   if ($numb{$rank}){$numb{$rank}++}else{$numb{$rank}=1; push(@r,$rank);};
   $cnt++;
} close RFILE;
#
my @sorted = sort { $a <=> $b } @r; # numerical sort

my $cur=0; my %covofrank;
foreach my $value (@sorted) {
   print "$value\n";
   $cur=$cur+$numb{$value};
   my $cover=100*$cur/$cnt;
   while($cover=~/\./ and substr($cover,0,-3)=~/\./) {$cover=substr($cover,0,-1)};
   $covofrank{$value}=$cover;
}

open (RFILE, $rfile) || die ("Could not find the file: $rfile");
#Read rank file:
while (my $text1 = <RFILE>) {
   $text1=~s/\n//;
   if($text1 =~ /^[%#]/) {
      print NFILE "$text1\n";
   }else{
      if($text1 =~ /\w/) {
         my @a=split(/\t/,$text1);
         my $rank=$a[$col];
         my $cov=$covofrank{$rank};
         print NFILE "$text1\t$cov\n"
      }else{print NFILE "$text1\n"}
   }
}

print "File $newname was generated\n";

exit;
