#!/usr/bin/perl -w

use IO::Handle;         #autoflush
use File::Copy;     # copy a file
use strict;
use warnings;
#use LWP::Simple; 

#*** If there are no arguments provided script exits writing "..."
if (@ARGV <2){print "USAGE:  perl ./ranks2cov_file.pl <.ranks file>\n"; exit};

my $cfile = $ARGV[0];
#Read rank file:
my %EA;
open (CFILE, $cfile) || die ("Could not find the file: $cfile");
my %cnt; my %score;
while (my $text = <CFILE>) {
   next if ($text =~ /^%/ or $text =~ /^#/ or $text !~ /\w/);
   $text=~s/\n//;
   my @a=split(/\t/,$text); next if($a[-1]!~/\d/);
   my $var=$a[0];
   $score{$var}=$a[-1];
   $cnt{$var}=1;
   $EA{$var}=$a[-1];
} close CFILE;

my $i=0;
while($ARGV[$i+1]){
   $i++;
   $cfile = $ARGV[$i];
   open (CFILE, $cfile) || die ("Could not find the file: $cfile");
   while (my $text = <CFILE>) {
      next if ($text =~ /^%/ or $text =~ /^#/ or $text !~ /\w/);
      $text=~s/\n//;
      my @a=split(/\t/,$text); next if($a[-1]!~/\d/);
      my $var=$a[0];
      if(!$cnt{$var}){$cnt{$var}=0; $score{$var}=0; print "variant $var was not found in previous .pred file(s)\n";};
      $score{$var}=$score{$var}+$a[-1];
      $cnt{$var}++;
   } close CFILE;
}

my %nr; my %ear; my %avr;
foreach my $var (keys %cnt) {
    next if ($cnt{$var}<$i+1);
    my $resi=substr($var,1,-1);
    if(!$nr{$resi}){$nr{$resi}=0; $ear{$resi}=0; $avr{$resi}=0;};
    if(!$EA{$var}){print "$var was not found in $ARGV[0]\nIs it the EA.pred file?\n"; exit; };
    $nr{$resi}++;
    $avr{$resi}=$avr{$resi}+$score{$var}/$cnt{$var};
    $ear{$resi}=$ear{$resi}+$EA{$var};#if($resi==1){print "$var\t$cnt{$var}\t$EA{$var}\t$score{$var}\t$ear{$resi}\t$avr{$resi}\n";};
}

my $resi=1;
open (SFILE, ">av.cov") || die ("Could not find the file: av.cov");
foreach my $var ( sort { substr($a,1,-1) <=> substr($b,1,-1) || substr($a,-1) cmp substr($b,-1)} keys %cnt) {
        if($resi!=substr($var,1,-1)){$resi=substr($var,1,-1); print SFILE "\n";};
        my $av=$score{$var}/$cnt{$var};
        if($cnt{$var}<$i+1){
            my $add=$avr{$resi}/$nr{$resi}-$ear{$resi}/$nr{$resi};
            $av=$EA{$var}+$add;
            #if($resi==1){print "$var\t$add\t$EA{$var}\t$score{$var}\t$avr{$resi}/$nr{$resi}-$ear{$resi}/$nr{$resi}\n";};
        }
        
        $av=sprintf("%.2f", $av);
        print SFILE "$var\t$av\n";
} close CFILE;

exit;
