#!/usr/bin/perl -w

use IO::Handle;         #autoflush
use File::Copy;     # copy a file
use strict;
use warnings;
#use LWP::Simple; 


#*** If there are no arguments provided script exits writing "..."
if (@ARGV <2){print "USAGE:  perl ./ranks2cov_file.pl <.ranks file>\n"; exit};

my $cfile = $ARGV[0];
#Read rank file:
open (CFILE, $cfile) || die ("Could not find the file: $cfile");
my %cnt; my %score;
while (my $text = <CFILE>) {
   next if ($text =~ /^%/ or $text =~ /^#/ or $text !~ /\w/);
   $text=~s/\n//;
   my @a=split(/\t/,$text); next if($a[-1]!~/\d/);
   my $var=$a[0];
   $score{$var}=$a[-1];
   $cnt{$var}=1;
} close CFILE;

my $i=0;
while($ARGV[$i+1]){
   $i++;
   $cfile = $ARGV[$i];
   open (CFILE, $cfile) || die ("Could not find the file: $cfile");
   while (my $text = <CFILE>) {
      next if ($text =~ /^%/ or $text =~ /^#/ or $text !~ /\w/);
      $text=~s/\n//;
      my @a=split(/\t/,$text); next if($a[-1]!~/\d/);
      my $var=$a[0];
      if(!$cnt{$var}){$cnt{$var}=0; $score{$var}=0; print "variant $var was not found in previous .pred file(s)\n";};
      $score{$var}=$score{$var}+$a[-1];
      $cnt{$var}++;
   } close CFILE;
}

my $resi=1;
open (SFILE, ">av.cov") || die ("Could not find the file: av.cov");
foreach my $var ( sort { substr($a,1,-1) <=> substr($b,1,-1) || substr($a,-1) cmp substr($b,-1)} keys %cnt) {
        if($resi!=substr($var,1,-1)){$resi=substr($var,1,-1); print SFILE "\n";};
        my $av=sprintf("%.2f", $score{$var}/$cnt{$var});
        print SFILE "$var\t$av\n";
} close CFILE;

exit;
